// OContainerView.h : interface of the COContainerView class
//


#pragma once

class COContainerCntrItem;

class COContainerView : public CView
{
protected: // create from serialization only
	COContainerView();
	DECLARE_DYNCREATE(COContainerView)

// Attributes
public:
	COContainerDoc* GetDocument() const;
	// m_pSelection holds the selection to the current COContainerCntrItem.
	// For many applications, such a member variable isn't adequate to
	//  represent a selection, such as a multiple selection or a selection
	//  of objects that are not COContainerCntrItem objects.  This selection
	//  mechanism is provided just to help you get started

	// TODO: replace this selection mechanism with one appropriate to your app
	COContainerCntrItem* m_pSelection;

// Operations
public:

// Overrides
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL IsSelected(const CObject* pDocItem) const;// Container support

// Implementation
public:
	virtual ~COContainerView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
    void wstawObiekt(CString objName, CString fileName = NULL);
protected:

// Generated message map functions
protected:
	afx_msg void OnDestroy();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnInsertObject();
	afx_msg void OnCancelEditCntr();
	afx_msg void OnFilePrint();
	DECLARE_MESSAGE_MAP()
public:
    afx_msg void OnFileZakoncz();
    afx_msg void OnFileEdytuj();
    afx_msg void OnFileOtworz();
    afx_msg void OnFileWstawdokumentword();
    afx_msg void OnFileWstawdokumentwordzpliku();
};

#ifndef _DEBUG  // debug version in OContainerView.cpp
inline COContainerDoc* COContainerView::GetDocument() const
   { return reinterpret_cast<COContainerDoc*>(m_pDocument); }
#endif

